﻿var progIdArray = ["serviceId", "serviceName", "camSelect", "descramStatus"];
var PROG_COL_NUM = 4;
var pidIdArray = ["check", "pidStr", "pidStatus"];
var PID_COL_NUM = 3;
var progNum;
var pidNum = [];
var showString = ["Show Detail", "显示详细"];
var hiddenString = ["Hidden Detail", "隐藏详细"];
//状态码的定义是为了版本兼容，让每个值固定的对应某个含义
var descrambleStatusCode = ["16", "32", "33", "48", "64", "238", "255"];
var DESCRAMBLE_CODE_NUM = 7;
var NO_DESCRAMBLE = 5;
var descrambStatusEn = ["Descrambling Failure", "No Entitlement", "Beyond Descrambling Capability", "No ECM", "ECM Error", "No Descramble", "Descrambling Success"];
var descrambStatusCn = ["解扰失败", "无授权", "解扰数量太多", "无ECM", "ECM丢包", "未解扰", "解扰成功"];
var descrambleStatusColor = ["#cc0000", "#DB6A05", "#DB6A05", "#DB6A05", "#DB6A05", "#333333", "#006600"];
var descrambStatus = [descrambStatusEn, descrambStatusCn];
var identifyData;
var confirmFlag = 0;
var refreshProgFlag = 0;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	setInterval("getStatus();", 3000);
	$("input[type=checkbox]").live("click", function()
	{
		if(top.groupAccess == USER)
		{
			DisableButton("applyBtn");
		}
		else
		{
			EnableButton("applyBtn");
		}
	});
});

function funcUpdateDisplay()
{
	if(top.groupAccess == USER)
	{
		DisableButton("applyBtn");
	}
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var data;
	var secondData;
	var length;
	var response;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + CAM_DESCRAMB + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response == "")
			{
				progNum = 0;
			}
			else
			{
				data = response.split(FIRST_DELIMITER);
				progNum = data.length;
			}
			DrawTableTwoRow("dataTable", "progDataRow", "progCaseRow", "pidDataRow", "pidCaseRow", progNum);
			pidNum = [];
			for(var i = 0; i < progNum; i++)
			{
				secondData = data[i].split(SECOND_DELIMITER);
				length = secondData.length;
				pidNum.push(length - 1);
				DrawTableRow("pidTable" + (i + 1), "pidRow", "PidRow", pidNum[i]);
			}
			if(progNum != 0)
			{
				updateTableData(data);
			}
			refreshFlag = true;  //刷新标识符设为true表示刷新成功
		}
	}
	xmlHttp.send(null);
}

function getStatus()
{
	var data;
	var paramData;
	var allProgData;
	var singleProgData;
	var curProgNum;
	var curPidNum;
	var response;
	var xmlHttp = GetHTTPObject();
	var newConfirmFlag;
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + CAM_DESCRAMB_STATUS + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response == "")
			{
				curProgNum = 0;
			}
			else
			{
				data = response.split(FIRST_DELIMITER);
				paramData = data[0]
				identifyData = data[1].split(SECOND_DELIMITER);
				newConfirmFlag = parseInt(identifyData[0], 10);
				refreshProgFlag = parseInt(identifyData[1], 10);
				if(refreshProgFlag == 1)
				{
					displayParam();
					return;				
				}
				if(confirmFlag != newConfirmFlag)
				{
					confirmFlag = newConfirmFlag;
					if(newConfirmFlag == 1)
					{
						if(language == ENGLISH)
						{
							alert('Stream datas have changed.Click the button of "Apply" to reset the descramble params!');
						}
						else
						{
							alert('流信息发生了变化,点击"应用"按钮重新进行设置!');
						}
						return;
					}
				}
				allProgData = paramData.split(SECOND_DELIMITER);
				curProgNum = allProgData.length - 1;
			}		
			/*if(curProgNum != progNum)
			{
				self.location.replace("cam_descramble" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);
				return;
			}*/
			for(var i = 0; i < progNum; i++)
			{
				singleProgData = allProgData[i].split(THIRD_DELIMITER);
				curPidNum = singleProgData.length - 1;
				for(var j = 0; j < DESCRAMBLE_CODE_NUM; j++)
				{
					if(singleProgData[0] == descrambleStatusCode[j])
					{
						$("#descramStatus" + (i + 1)).html(descrambStatus[language][j]);
						$("#descramStatus" + (i + 1)).css("color", descrambleStatusColor[j]);
						break;
					}
				}
				if(j == DESCRAMBLE_CODE_NUM)
				{
					$("#descramStatus" + (i + 1)).html(descrambStatus[language][NO_DESCRAMBLE]);
					$("#descramStatus" + (i + 1)).css("color", descrambleStatusColor[NO_DESCRAMBLE]);
				}
				/*if(curPidNum != pidNum[i])
				{
					self.location.replace("cam_descramble" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);
					return;
				}*/
				for(var k = 0; k < pidNum[i]; k++)
				{
					for(var j = 0; j < DESCRAMBLE_CODE_NUM; j++)
					{
						if(singleProgData[k + 1] == descrambleStatusCode[j])
						{
							$("#pidTable" + (i + 1) + " #pidStatus" + (k + 1)).html(descrambStatus[language][j]);
							$("#pidTable" + (i + 1) + " #pidStatus" + (k + 1)).css("color", descrambleStatusColor[j]);
							break;
						}
					}
					if(j == DESCRAMBLE_CODE_NUM)
					{
						$("#pidTable" + (i + 1) + " #pidStatus" + (k + 1)).html(descrambStatus[language][NO_DESCRAMBLE]);
						$("#pidTable" + (i + 1) + " #pidStatus" + (k + 1)).css("color", descrambleStatusColor[NO_DESCRAMBLE]);
					}
				}
			}
		}
	}
	xmlHttp.send(null);
}

function updateTableData(data)
{
	var secondData;
	var progData;
	var pidData;
	
	for(var i = 0; i < progNum; i++)
	{
		secondData = data[i].split(SECOND_DELIMITER);
		progData = secondData[0].split(THIRD_DELIMITER);
		for(var j = 0; j < PROG_COL_NUM; j++)
		{
			if(j == 2)
			{
				$("#" + progIdArray[j] + (i + 1)).val(progData[j]);
			}
			else if(j == 3)
			{
				for(var k = 0; k < DESCRAMBLE_CODE_NUM; k++)
				{
					if(progData[j] == descrambleStatusCode[k])
					{
						$("#" + progIdArray[j] + (i + 1)).html(descrambStatus[language][k]);
						$("#" + progIdArray[j] + (i + 1)).css("color", descrambleStatusColor[k]);
						break;
					}
				}
				if(k == DESCRAMBLE_CODE_NUM)
				{
					$("#" + progIdArray[j] + (i + 1)).html(descrambStatus[language][NO_DESCRAMBLE]);
					$("#" + progIdArray[j] + (i + 1)).css("color", descrambleStatusColor[NO_DESCRAMBLE]);
				}
			}
			else
			{
				$("#" + progIdArray[j] + (i + 1)).html(progData[j]);
			}
		}
		for(var j = 0; j < pidNum[i]; j++)
		{
			pidData = secondData[j + 1].split(THIRD_DELIMITER);
			for(var k = 0; k < PID_COL_NUM; k++)
			{
				if(k == 0)
				{
					if(parseInt(pidData[k], 10) == 1)
					{
						$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).prop("checked", true);
					}
					else
					{
						$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).prop("checked", false);
					}
				}
				else if(k == 2)
				{
					for(var z = 0; z < DESCRAMBLE_CODE_NUM; z++)
					{
						if(pidData[k] == descrambleStatusCode[z])
						{
							$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).html(descrambStatus[language][z]);
							$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).css("color", descrambleStatusColor[z]);
							break;
						}
					}
					if(z == DESCRAMBLE_CODE_NUM)
					{
						$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).html(descrambStatus[language][NO_DESCRAMBLE]);
						$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).css("color", descrambleStatusColor[NO_DESCRAMBLE]);
					}
				}
				else
				{
					$("#pidTable" + (i + 1) + " #" + pidIdArray[k] + (j + 1)).html(pidData[k]);
				}
			}
		}
	}
	
	for(var i = 0; i < progNum; i++)
	{
		$("#pidDataRow" + (i + 1)).css("display", "none");
	}
	$("#detailBtn").val(showString[language]);
	display = false;
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	data = "type=" + CAM_DESCRAMB + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	
	for(var i = 0; i < progNum; i++)
	{
		if(i == 0)
		{
			data = $("#camSelect" + (i + 1)).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#camSelect" + (i + 1)).val();
		}
		for(var j = 0; j < pidNum[i]; j++)
		{
			if($("#pidTable" + (i + 1) + " #check" + (j + 1)).prop("checked") == true)
			{
				data += SECOND_DELIMITER + 1;
			}
			else
			{
				data += SECOND_DELIMITER + 0;
			}
		}
	}
	
	return data;
}

var display = false;
function displayDetail()
{
	if(display == false)
	{
		for(var i = 0; i < progNum; i++)
		{
			$("#pidDataRow" + (i + 1)).css("display", "");
		}
		$("#detailBtn").val(hiddenString[language]);
		display = true;
	}
	else
	{
		for(var i = 0; i < progNum; i++)
		{
			$("#pidDataRow" + (i + 1)).css("display", "none");
		}
		$("#detailBtn").val(showString[language]);
		display = false;
	}
}

function changeCam(obj)
{
	var index = obj.attr("id").slice(9) - 1;
	if(parseInt(obj.val(), 10) == 0)
	{
		for(var i = 0; i < pidNum[index]; i++)
		{
			$("#pidTable" + (index + 1) + " #check" + (i + 1)).prop("checked", false);
		}
	}
	else
	{
		for(var i = 0; i < pidNum[index]; i++)
		{
			$("#pidTable" + (index + 1) + " #check" + (i + 1)).prop("checked", true);
		}
	}
}