﻿var objIdArray = ["portSwitch", "search", "polarize", "khzSwitch", "standard", "downFreq", "localFreq", "symbolRate"];
var ROW_NUM = 8;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay()
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_CONFIG + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);						
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				refreshFlag = true;  //刷新标识符设为true表示刷新成功
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;
	var differenceValue;

	returnFlag = ValidateParam($("#downFreq"), "INT_DEC", 1, 99999, "<Down Frequency(MHz)>", "<下行频率(MHz)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#localFreq"), "INT_DEC", 1, 99999, "<Local Frequency(MHz)>", "<本振频率(MHz)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#symbolRate"), "INT_DEC", 1000, 45000, "<Symbol Rate(Ksps)>", "<符号率(Ksps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	differenceValue = parseInt($("#downFreq").val(), 10) - parseInt($("#localFreq").val(), 10)
	if((Math.abs(differenceValue) < 950) || (Math.abs(differenceValue) > 2150))
	{
		if(language == ENGLISH)
		{
			alert("The absolute value of the difference between downlink frequency and local frequency must be between 950 and 2150!");
		}
		else
		{
			alert("下行频率和本振频率的差值的绝对值必须在950和2150之间！");
		}		
		return false;
	}
	
	return true;
}

function generateData()
{
	var data;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val()
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val()
		}
	}
	return data;
}

