﻿var objIdArray = ["ipAddress", "subnetMask", "gateWay", "mac"];
var ROW_NUM = 3;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + CARD_SYSTEM + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				$("#" + objIdArray[ROW_NUM]).html(data[ROW_NUM]);
			    refreshFlag = true;
			}			
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + CARD_SYSTEM + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;
	var dhcpSwitch = parseInt($("#dhcpSwitch").val(), 10);

	returnFlag = ValidateIP($("#" + objIdArray[0]), "UNICAST_IP_ADDR", "<IP>", "<IP 地址>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateIP($("#" + objIdArray[1]), "SUBNET_MASK", "<Subnet Mask>", "<子网掩码>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateSubnetMaskRelation($("#" + objIdArray[0]).val(), $("#" + objIdArray[1]), "<Subnet Mask>", "<子网掩码>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateIP($("#" + objIdArray[2]), "GATEWAY", "<Gateway>", "<网关>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateGatewayRelation($("#" + objIdArray[0]).val(), $("#" + objIdArray[1]).val(), $("#" + objIdArray[2]), "<Gateway>", "<网关>", language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;
}
