﻿var videoEncodeIdArray = ["switch", "bitrate", "mode", "resolution", "frameRate", "profile", "level", "syncMode", "aspectRatio", "gopStruct", "gopLen", "idrFrequency", "entropyCoding", "unlockCtrl", "testPattern", "passDelay", "adaptGop", "adaptSps", "adaptPps"];
var cvbsInterfaceIdArray = ["brightness", "contrast", "saturation", "hue"];
var txtIdArray = ["positionX", "positionY", "textContent"];
var vbiIdArray = ["ttSwitch", "afdMode", "ccSwitch"];
var objIdArray = [videoEncodeIdArray, cvbsInterfaceIdArray, txtIdArray, vbiIdArray];
var SEC_NUM = 4;
var TEXT_PARAM = 2;
var TEXT_CONTENT = 2;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var sectionData;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_VIDEO + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);						
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < SEC_NUM; i++)
				{
					sectionData = data[i].split(SECOND_DELIMITER);
					length = sectionData.length;
					for(var j = 0; j < length; j++)
					{
						$("#" + objIdArray[i][j]).val(sectionData[j]);
					}
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_VIDEO + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;
	
	returnFlag = ValidateParam($("#bitrate"), "INT_DEC", 300000, 50000000, "<Video Bitrate(bps)>", "<视频码率(bps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#gopLen"), "INT_DEC", 1, 30, "<GOP Size>", "<GOP长度>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#idrFrequency"), "INT_DEC", 0, 15, "<IDR Frequency(GOPs)>", "<IDR频率(GOPs)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#passDelay"), "INT_DEC", 0, 500, "<Pass Delay(ms)>", "<视频透传延时(ms)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#brightness"), "INT_DEC", 0, 255, "<Brightness>", "<亮度>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#contrast"), "INT_DEC", 0, 255, "<Contrast>", "<对比度>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#saturation"), "INT_DEC", 0, 255, "<Saturation>", "<饱和度>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#hue"), "INT_DEC", 64, 191, "<Hue>", "<色度>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#positionX"), "INT_DEC", 1, 1919, "<Start PosX>", "<起始点横坐标>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#positionY"), "INT_DEC", 1, 1079, "<Start PosX>", "<起始点纵坐标>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#textContent"), "LENGTH", 0, 32, "<Text Content>", "<文字内容>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateName($("#textContent"), language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;
}

function generateData()
{
	var data;
	var length;
	
	for(var i = 0; i < SEC_NUM; i++)
	{
		length = objIdArray[i].length;
		for(var j = 0; j < length; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + objIdArray[i][j]).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
			else if((i == TEXT_PARAM) && (j == TEXT_CONTENT))
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[i][j]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
		}
	}
	
	return data;
}