﻿var objIdArray = ["serviceId", "serviceName", "serviceProvider", "pmtPid", "pcrPid", "videoPid", "audio1Pid", "audio2Pid", "audio3Pid", "audio4Pid", "ttPid"];
var OBJ_NUM = 11;
var SERVICE_NAME = 1;
var PROVIDER_NAME = 2;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var sectionData;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_TS + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);						
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < OBJ_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_TS + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;
	
	returnFlag = ValidateParam($("#serviceId"), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#serviceName"), "LENGTH", 0, 15, "<Service Name>", "<业务名称>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateName($("#serviceName"), language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#serviceProvider"), "LENGTH", 0, 15, "<Service Provider>", "<业务提供商>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateName($("#serviceProvider"), language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#pmtPid"), "INT_DEC_HEX", 20, 8189, "<PMT PID>", "<PMT PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#pcrPid"), "INT_DEC_HEX", 20, 8189, "<PCR PID>", "<PCR PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#videoPid"), "INT_DEC_HEX", 20, 8189, "<Video PID>", "<视频PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#audio1Pid"), "INT_DEC_HEX", 20, 8189, "<Audio 1 PID>", "<音频1 PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#audio2Pid"), "INT_DEC_HEX", 20, 8189, "<Audio 2 PID>", "<音频2 PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#audio3Pid"), "INT_DEC_HEX", 20, 8189, "<Audio 3 PID>", "<音频3 PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#audio4Pid"), "INT_DEC_HEX", 20, 8189, "<Audio 4 PID>", "<音频4 PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#ttPid"), "INT_DEC_HEX", 20, 8189, "<TT PID>", "<TT PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;
}

function generateData()
{
	var data;
	
	for(var i = 0; i < OBJ_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val()
		}
		else if((i == SERVICE_NAME) || (i == PROVIDER_NAME))
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	
	return data;
}