﻿var videoEncodeIdArray = ["switch", "encodingType", "bitrate", "resolution", "gopMax", "gopMin", "gopLen", "codingMode", "rateCtrl","sceneChange", "aspectRatio", "unlockCtrl", "testPattern", "syncMode", "preProcessing", "eteDelay", "pcrOffset"];
var H264EncodeArray = ["avcProfile", "avcLevel", "idrFrequency", "entropyCoding"];
var mpeg2EncodeArray = ["mp2Profile", "mp2Level"];
var vbiIdArray = ["afdDar", "afdInputMode", "afdCode"];
var superIdArray = ["bitDepth", "chromaFormat", "sysDelay"];
var pipIdArray = ["pipSwitch", "pipResolution", "pipBitrate"];
var objIdArray = [videoEncodeIdArray, H264EncodeArray, mpeg2EncodeArray, vbiIdArray, superIdArray, pipIdArray];
var SEC_NUM = 6;
var identifyData;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var sectionData;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_VIDEO + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);						
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				identifyData = data[SEC_NUM].split(SECOND_DELIMITER);
				for(var i = 0; i < SEC_NUM; i++)
				{
					sectionData = data[i].split(SECOND_DELIMITER);
					length = sectionData.length;
					for(var j = 0; j < length; j++)
					{
						$("#" + objIdArray[i][j]).val(sectionData[j]);
					}
				}
				disabledParam();
				if(identifyData[0] == 0)
				{ 
					if(identifyData[1] == 0)
					{
						$("#bitrate").attr("disabled", false);
					}
					else
					{
						$("#bitrate").attr("disabled", true);
					}
					$("#bitDepth").attr("disabled", true);
					$("#chromaFormat").attr("disabled", true);
					$("#sysDelay").attr("disabled", true);
				}
				else if(identifyData[0] == 1)
				{
					$("#gopMin").attr("disabled", true);
					$("#codingMode").attr("disabled", true);
					$("#rateCtrl").attr("disabled", true);
					$("#sceneChange").attr("disabled", true);
					$("#preProcessing").attr("disabled", true);
					$("#eteDelay").attr("disabled", true);
					$("#pcrOffset").attr("disabled", true);
					$("#avcProfile").attr("disabled", true);
					$("#avcLevel").attr("disabled", true);
					$("#mp2Level").attr("disabled", true);
					$("#afdDar").attr("disabled", true);
					$("#afdInputMode").attr("disabled", true);
					$("#afdCode").attr("disabled", true);
				}
				else
				{
					$("#bitrate").attr("disabled", true);
					$("#resolution").attr("disabled", true);
					$("#gopMax").attr("disabled", true);
					$("#gopMin").attr("disabled", true);
					$("#codingMode").attr("disabled", true);
					$("#rateCtrl").attr("disabled", true);
					$("#avcProfile").attr("disabled", true);
					$("#avcLevel").attr("disabled", true);
					$("#bitDepth").attr("disabled", true);
					$("#chromaFormat").attr("disabled", true);
					$("#sysDelay").attr("disabled", true);
					$("#entropyCoding").attr("disabled", true);
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function disabledParam()
{
	$("#bitrate").attr("disabled", false);
	$("#resolution").attr("disabled", false);
	$("#gopMax").attr("disabled", false);
	$("#gopMin").attr("disabled", false);
	$("#codingMode").attr("disabled", false);
	$("#rateCtrl").attr("disabled", false);
	$("#sceneChange").attr("disabled", false);
	$("#preProcessing").attr("disabled", false);
	$("#eteDelay").attr("disabled", false);
	$("#pcrOffset").attr("disabled", false);
	$("#avcProfile").attr("disabled", false);
	$("#avcLevel").attr("disabled", false);
	$("#mp2Level").attr("disabled", false);
	$("#afdDar").attr("disabled", false);
	$("#afdInputMode").attr("disabled", false);
	$("#afdCode").attr("disabled", false);
	$("#bitDepth").attr("disabled", false);
	$("#chromaFormat").attr("disabled", false);
	$("#sysDelay").attr("disabled", false);
	$("#entropyCoding").attr("disabled", false);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_VIDEO + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;
	
	returnFlag = ValidateParam($("#bitrate"), "INT_DEC", 300000, 50000000, "<Video Bitrate(bps)>", "<视频码率(bps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#gopLen"), "INT_DEC", 0, 600, "<GOP Size>", "<GOP长度>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#idrFrequency"), "INT_DEC", 0, 255, "<IDR Frequency(GOPs)>", "<IDR频率(GOPs)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#eteDelay"), "INT_DEC", 3500, 5000, "<ETE Delay(ms)>", "<ETE延时(ms)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateParam($("#pcrOffset"), "INT_DEC", -500, 500, "<PCR Offset(ms)>", "<PCR偏移量(ms)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	
	returnFlag = ValidateParam($("#pipBitrate"), "INT_DEC", 96000, 400000, "<PIP Bitrate(kbps)>", "<PIP码率(kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	return true;
}

function generateData()
{
	var data;
	var length;
	
	for(var i = 0; i < SEC_NUM; i++)
	{
		length = objIdArray[i].length;
		for(var j = 0; j < length; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + objIdArray[i][j]).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[i][j]).val();
			}
		}
	}
	
	return data;
}