﻿var MPEG1 = 1;
var AAC_LC = 2;
var HEAAC_V1 = 3;
var HEAAC_V2 = 4;

var DUAL = 1;
var STEREO = 2;

var NO_MULTI_MODULE = 0;


window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
}

$(document).ready(function()
{
	InitFunctionMenu(portMenuArray[language], PORT_AUDIO_MENU, portPageType);
	InitParam("port_audio.xml");
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, BUTTON_CHANGE);
	$(document).on("change", "#type1", function()
	{
		var index = $(this).attr("id").slice("4");
		displayDynamicMode(index);
		displayDynamicList(index);
	});
	$(document).on("change", "#mode1", function()
	{
		var index = $(this).attr("id").slice("4");
		displayDynamicList(index);
	});
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayDynamicMode(index)
{
	var audioType = parseInt($("#type" + index).val(), 10);
	var $modeObj = $("#mode" + index);
	$modeObj.empty();
	if((audioType == MPEG1) || (audioType == HEAAC_V2))
	{
		if(language == ENGLISH)
		{
			$modeObj.append('<option value="2" selected="selected">Stereo</option>');
		}
		else
		{
			$modeObj.append('<option value="2" selected="selected">立体声</option>');
		}	
	}
	else if((audioType == HEAAC_V1) || (audioType == AAC_LC))
	{
		if(language == ENGLISH)
		{
			//$modeObj.append('<option value="1">Dual</option>');
			$modeObj.append('<option value="2" selected="selected">Stereo</option>');
			$modeObj.append('<option value="3">L Channel Mono</option>');
			$modeObj.append('<option value="4">R Channel Mono</option>');
			$modeObj.append('<option value="5">LR Mixed Mono</option>');
		}
		else
		{
			//$modeObj.append('<option value="1">双声道</option>');
			$modeObj.append('<option value="2" selected="selected">立体声</option>');
			$modeObj.append('<option value="3">左声道</option>');
			$modeObj.append('<option value="4">右声道</option>');
			$modeObj.append('<option value="5">混合单声道</option>');
		}
	}
}
function displayParam() 
{
	var data;
	var sectionData;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_AUDIO + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);						
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				if(identifierArray.length != 0)
				{
					identifierData = data[data.length - 1].split(SECOND_DELIMITER);
				}
				for(var i = 0; i < objIdArray.length; i++)
				{
					sectionData = data[i].split(SECOND_DELIMITER);
					length = sectionData.length;
					for(var j = 0; j < length; j++)
					{
						$("#" + objIdArray[i][j]).val(sectionData[j]);
						if(objIdArray[i][j] == "type1")
						{
							var index = objIdArray[i][j].slice("4");
							displayDynamicMode(index);
						}
						if(objIdArray[i][j] == "mode1")
						{
							var index = objIdArray[i][j].slice("4");
							displayDynamicList(index);
						}
					}			
				}
				if(identifierData[0] == C130_AS)
				{
					//$("#audio1SecContent").css("height", "120px");
					$("#audioSrcSel1Li").hide();
					$("#noInputMode1Li").hide();
					$("#embeddedChannel1Li").hide();
					
					//$("#audio2SecContent").css("height", "120px");
					$("#audioSrcSel2Li").hide();
					$("#noInputMode2Li").hide();
					$("#embeddedChannel2Li").hide();
					
					$("#audioSrcSel3Li").hide();
					$("#noInputMode3Li").hide();
					$("#embeddedChannel3Li").hide();
					
					$("#dolbybypassBar").hide();
					$("#dolbybypassContent").hide();
					
				}
				else
				{
					//$("#audio1SecContent").css("height", "145px");
					$("#audioSrcSel1Li").show();
					$("#noInputMode1Li").show();
					$("#embeddedChannel1Li").show();
					
					//$("#audio2SecContent").css("height", "145px");
					$("#audioSrcSel2Li").show();
					$("#noInputMode2Li").show();
					$("#embeddedChannel2Li").show();
					
					$("#audioSrcSel3Li").show();
					$("#noInputMode3Li").show();
					$("#embeddedChannel3Li").show();
					
					$("#dolbybypassBar").show();
					$("#dolbybypassContent").show();
				}
				var audioDisplayCtrl = Number(identifierData[1]).toString(2);
				for(var i = 0; i < 8; i++)
				{
					if(audioDisplayCtrl.length < 8)
					{
						audioDisplayCtrl = "0" + audioDisplayCtrl;
					}
				}
				var displayCnt = 0;
				for(var i = 0, len = audioDisplayCtrl.length; i < len; i++)
				{
					if(audioDisplayCtrl.charAt(i) == OFF)
					{
						$("#audioSec" + (8 - i) + "Bar").hide();
						$("#audioSec" + (8 - i) + "Content").hide();
					}
					else
					{
						$("#audioSec" + (8 - i) + "Bar").show();
						$("#audioSec" + (8 - i) + "Content").show();
						displayCnt++;
					}
				}
				if(displayCnt == 1)
				{
					$("#audioSec1Bar div").html($("#audioSec1Bar div").html().replace("1", ""));
				}
				else
				{
					$("#audioSec1Bar div").html($("#audioSec1Bar div").html().replace("1", "") + "1");
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function displayDynamicList(index)
{
	var $bitrateObj = $("#bitrate" + index);
	$bitrateObj.empty();
	var audioType = parseInt($("#type" + index).val(), 10);
	var mode = parseInt($("#mode" + index).val(), 10);
	if((audioType == AAC_LC) && (mode == STEREO))
	{
		$bitrateObj.append('<option value="0">32Kbps</option>');
		$bitrateObj.append('<option value="1">48Kbps</option>');
		$bitrateObj.append('<option value="2">56Kbps</option>');
		$bitrateObj.append('<option value="3">64Kbps</option>');
		$bitrateObj.append('<option value="4">80Kbps</option>');
		$bitrateObj.append('<option value="5">96Kbps</option>');
		$bitrateObj.append('<option value="6">112Kbps</option>');
		$bitrateObj.append('<option value="7">128Kbps</option>');
		$bitrateObj.append('<option value="8">160Kbps</option>');
		$bitrateObj.append('<option value="9" selected="selected">192Kbps</option>');
		$bitrateObj.append('<option value="10">224Kbps</option>');
		$bitrateObj.append('<option value="11">256Kbps</option>');
		$bitrateObj.append('<option value="12">320Kbps</option>');
		$bitrateObj.append('<option value="13">384Kbps</option>');
	}
	else if(((audioType == AAC_LC) && (mode > 2)) || ((audioType == HEAAC_V1) && (mode == STEREO)))
	{
		$bitrateObj.append('<option value="0">32Kbps</option>');
		$bitrateObj.append('<option value="1">48Kbps</option>');
		$bitrateObj.append('<option value="2">56Kbps</option>');
		$bitrateObj.append('<option value="3">64Kbps</option>');
		$bitrateObj.append('<option value="4">80Kbps</option>');
		$bitrateObj.append('<option value="5">96Kbps</option>');
		$bitrateObj.append('<option value="6">112Kbps</option>');
		$bitrateObj.append('<option value="7">128Kbps</option>');
		$bitrateObj.append('<option value="8">160Kbps</option>');
		$bitrateObj.append('<option value="9" selected="selected">192Kbps</option>');
	}
	else if((audioType == MPEG1) && (mode == STEREO))
	{
		$bitrateObj.append('<option value="5">96Kbps</option>');
		$bitrateObj.append('<option value="6">112Kbps</option>');
		$bitrateObj.append('<option value="7">128Kbps</option>');
		$bitrateObj.append('<option value="8">160Kbps</option>');
		$bitrateObj.append('<option value="9" selected="selected">192Kbps</option>');
	}
	else if(((audioType == HEAAC_V1) && (mode > 2)) || ((audioType == HEAAC_V2) && (mode == STEREO)))
	{
		$bitrateObj.append('<option value="0">32Kbps</option>');
		$bitrateObj.append('<option value="1">48Kbps</option>');
		$bitrateObj.append('<option value="2">56Kbps</option>');
		$bitrateObj.append('<option value="3">64Kbps</option>');
		$bitrateObj.append('<option value="4">80Kbps</option>');
		$bitrateObj.append('<option value="5">96Kbps</option>');
	}
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	for(var i=1;i<=8;i++){
		if( ValidateParam($("#codingDelay" +i), "INT_DEC", -500, 500, "Audio Coding Delay", "编码延迟", language, "") == false)
		{
			return;
		}
	}
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_AUDIO + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}